package com.exeample.cris.bubbelgame;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;

import java.util.Random;
public class Bubble implements View.OnClickListener {
    private OnBurstListener burstListener;
    interface OnBurstListener {
        void onBurst(Bubble b);
    }
    private float x,y,vx,vy,size;
    private float oben, unten, links,rechs;
    //ViewGroup container;
    private int lifetime;
     ImageView view;
    private int LIFETIME = 1000;
    public Bubble (  FrameLayout container,FrameLayout spielfeld,float vMax, float sizeMax, Random rnd, Drawable drawable, OnBurstListener listener){

        burstListener = listener;
//        ViewGroup container = contex.findViewById(R.id.playField);
        lifetime = LIFETIME;
        size = (0.5f + rnd.nextFloat() / 2) * sizeMax;

        x = rnd.nextFloat() * (spielfeld.getWidth()-size);
        y = rnd.nextFloat() * (spielfeld.getHeight()-size);
        vx = rnd.nextFloat() * vMax * (rnd.nextBoolean()?1:-1);
        vy = rnd.nextFloat() * vMax * (rnd.nextBoolean()?1:-1);

        links = spielfeld.getLeft();
        rechs = spielfeld.getRight();
        oben = spielfeld.getTop();
        unten = spielfeld.getBottom();
        int w = spielfeld.getWidth();
        int h = spielfeld.getHeight();

        view = new ImageView(container.getContext());
        view.setImageDrawable(drawable);
        view.setOnClickListener(this);
       //ViewGroup.LayoutParams params = container.getLayoutParams();
        container.addView(view);

        move();
    }
    public void move() {



        x += vx;
        y += vy;

        if (y <= oben){ y=oben; vy= -vy; }
        if (y >= unten-size ){ y=unten-size; vy= -vy; }
        if (x<=links ){ x=links; vx= -vx; }
        if (x>=rechs-size){ x=rechs-size; vx= -vx;}

        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) view.getLayoutParams();
        params.width = Math.round(size);
        params.height = Math.round(size);
        params.leftMargin = Math.round(x);
        params.topMargin = Math.round(y);
        params.gravity = Gravity.LEFT + Gravity.TOP;
        view.setLayoutParams(params);
        lifetime--;
        if(lifetime <= 0) burst();
    }
    private void burst(){
        ViewGroup parent = (ViewGroup) view.getParent();
        parent.removeView(view);
        burstListener.onBurst(this);
    }
    @Override
    public void onClick(View v) {
        burst();
    }
}