package com.exeample.cris.bubbelgame;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
public class MainActivity extends BaseGameActivity implements View.OnClickListener, Bubble.OnBurstListener {
    private int points,countdown,rounds;
    private ViewGroup container;
    public  ViewGroup spielFeld;

    private TextView btnStart, btnHighscore,btnQuit, btnPlayAgain;
    private int BUBBLE_ID = 666666;
    private ImageView bubbleView;
    private Random rnd = new Random();
    private Handler handler = new Handler();
    private int scoreHighscore;
    private static final int BUBBLE_MAX = 0;
    private static float V_MAX = 0.5f;
    private static final float SIZE_MAX = 128f;
    private Drawable bubbleDrawable ;
    private Set <Bubble> bubbles = new HashSet<Bubble>();
    private ScheduledExecutorService executor;
    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        bubbleDrawable = getResources().getDrawable(R.drawable.ic_launcher_background);
    }
    private void showMenuFragment(){
        container =(FrameLayout)findViewById(R.id.lGesamt);
        spielFeld =(FrameLayout) findViewById(R.id.playField);
        findViewById(R.id.lKopf).setVisibility(View.GONE);
        findViewById(R.id.lFuss).setVisibility(View.GONE);

        spielFeld.addView(getLayoutInflater().inflate(R.layout.menu_layout, null));
        btnStart = findViewById(R.id.start);
        btnStart.setOnClickListener(this);
    }

    private void newGame(){
        container = findViewById(R.id.lGesamt);
        spielFeld = findViewById(R.id.playField);
        spielFeld.removeAllViews();
        //spielFeld.addView(getLayoutInflater().inflate(R.layout.game_layout,null));
        findViewById(R.id.lKopf).setVisibility(View.VISIBLE);
        findViewById(R.id.lFuss).setVisibility(View.VISIBLE);

        bubbles.add(new Bubble((FrameLayout) container, (FrameLayout)spielFeld, scale(V_MAX), scale(SIZE_MAX), rnd, bubbleDrawable, this));
        executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(moveRunnable, 0 , 50, TimeUnit.MILLISECONDS);
        points = 0;
        rounds = 1;
        initRound();
    }
    private Runnable moveRunnable = new Runnable() {
        @Override
        public void run() {
            for (final Bubble b : bubbles){
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        b.move();
                    }
                });
            }
        }
    };
    private void showHighscoreFragment(){
        //container = findViewById(R.id.container);
        spielFeld.removeAllViews();
        findViewById(R.id.lKopf).setVisibility(View.GONE);
        findViewById(R.id.lFuss).setVisibility(View.GONE);

    }
    private void showGameOverFragment(){
        //container = findViewById(R.id.container);
        findViewById(R.id.lKopf).setVisibility(View.GONE);
        findViewById(R.id.lFuss).setVisibility(View.GONE);
        spielFeld.removeAllViews();
        spielFeld.addView(getLayoutInflater().inflate(R.layout.gameover_layout, null));
        btnPlayAgain = findViewById(R.id.btnPlayAgain);
        btnPlayAgain.setOnClickListener(this);
        btnQuit = findViewById(R.id.btnQuit);
        btnQuit.setOnClickListener(this);
    }
    private void initRound() {
        countdown = 10;
        ViewGroup container = findViewById(R.id.playField);
        spielFeld.removeAllViews();
        update();
        handler.postDelayed(runnable, 1000-rounds*50);
    }
    private void fillTextView(int id, String text){
        TextView tv = findViewById(id);
        tv.setText(text);
    }
    private void update() {
        loadHighscore();
        fillTextView(R.id.tvHighscore, Integer.toString(scoreHighscore));
        fillTextView(R.id.tvRounds, Integer.toString(rounds));
        fillTextView(R.id.tvPoints, Integer.toString(points));
        fillTextView(R.id.tvCountdown, Integer.toString(countdown * 1000));
    }
    private void loadHighscore() {
        SharedPreferences sharedPreferences = getPreferences(MODE_PRIVATE);
        scoreHighscore = sharedPreferences.getInt("highscore", 0);
    }
    private void saveScoreHighscore(int points) {
        scoreHighscore = points;
        SharedPreferences sp = getPreferences(MODE_PRIVATE);
        SharedPreferences.Editor e = sp.edit();
        e.putInt("highscore", scoreHighscore);
        e.commit();
    }
    private void countdown(){
        countdown--;
        update();
    }
    private Runnable runnable = new Runnable() {
        @Override
        public void run() {
            countdown();
        }
    };
    @Override
    protected void onPause(){
        super.onPause();
        executor.shutdown();
        bubbles.clear();
        handler.removeCallbacks(runnable);
    }
    @Override
    protected void onResume(){
        super.onResume();
        showMenuFragment();
    }
    @Override
    public void onClick(View v) {

            newGame();


    }
    @Override
    public void onBurst(Bubble b) {
        bubbles.remove(b);
        handler.removeCallbacks(runnable);
        Toast.makeText(this, ".string.toastText", Toast.LENGTH_SHORT).show();
        points += countdown * 1000;
        rounds++;
        V_MAX++;
        initRound();
        for (int i = 0; i <= BUBBLE_MAX; i++){
            bubbles.remove(b);
            spielFeld = (FrameLayout) findViewById(R.id.playField);
            bubbles.add(new Bubble((FrameLayout) container,(FrameLayout)spielFeld, scale(V_MAX), scale(SIZE_MAX), rnd, bubbleDrawable, this));
        }
    }
}