package de.jogimuc.downloadingimages;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;
import com.chariotsolutions.example.http.Api;
import com.chariotsolutions.example.http.AuthenticationParameters;
import com.chariotsolutions.example.http.IOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = MainActivity.class.getSimpleName();

    ImageView downloadImg;


    String caCertificateName = "client-test.pem";
    String clientCertificateName = "client-test.p12";
    String clientCertificatePassword ="xxxxx";
    String exampleUrl ="https://3xxxxxxxx.eu" ;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        String result ="";
        copyzerti(this);

        ImageDownloader task = new ImageDownloader();

        try {
          result= task.execute("https://3xxxxxx.eu").get();

        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
        updateOutput(result);
    }


    private void updateOutput(String text) {
        TextView mainTextView = (TextView) findViewById(R.id.mainTextView);
        mainTextView.setText(mainTextView.getText() + "\n\n" + text);
    }



    public class ImageDownloader extends AsyncTask<String, Void, String> {
        private Api exampleApi;
        @Override
        protected  String doInBackground(String... urls) {
            String result = "";

            try {
                AuthenticationParameters authParams = new AuthenticationParameters();
                authParams.setClientCertificate(getClientCertFile());
                authParams.setClientCertificatePassword(clientCertificatePassword);
                authParams.setCaCertificate(readCaCert());

                exampleApi = new Api(authParams);

                result = exampleApi.doGet(exampleUrl);
                int responseCode = exampleApi.getLastResponseCode();

         } catch (Exception ex) {
                Log.e(TAG, "failed to create timeApi", ex);
                updateOutput(ex.toString());
            }


          return result;
        }

    }


    private  File getClientCertFile() {
        File externalStorageDir = Environment.getExternalStorageDirectory();
        return new File(externalStorageDir, clientCertificateName);
    }
    private String readCaCert() throws Exception {
        AssetManager assetManager = getAssets();
        InputStream inputStream = assetManager.open(caCertificateName);
        return IOUtil.readFully(inputStream);
    }

    public  void  copyzerti(Context context) {
        InputStream myInput = null;
        OutputStream myOutput = null;
        try {
            // Open local db from assets as the input stream
            myInput = context.getAssets().open(clientCertificateName);

            String st = Environment.getExternalStorageDirectory().toString()+"/"+clientCertificateName;
            myOutput = new FileOutputStream(new File(st));

            // transfer bytes from the inputfile to the outputfile
            byte[] buffer = new byte[1024];
            int length;
            while ((length = myInput.read(buffer)) > 0) {
                myOutput.write(buffer, 0, length);
            }

            // Close the streams
            myOutput.flush();
            myInput.close();
            myOutput.close();

        } catch (IOException e) {
            e.printStackTrace();
        }

    }


}
