package com.example.jogimuc.myapplication;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.app.RemoteInput;
import android.support.v4.app.TaskStackBuilder;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;

public class MainActivity extends AppCompatActivity {


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
                        .setAction("Action", null).show();
            }
        });

        sendCarNotification(this, "Test-Nachricht", "Hallo das ist eine Nachricht");

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    public static void sendCarNotification(Context c, String title, String message) {


        int thisConversationId = 0;

        Intent msgReadIntent = new Intent()
                .addFlags(Intent.FLAG_INCLUDE_STOPPED_PACKAGES)
                .setAction("com.myapp.android.messagingservice.MY_ACTION_MESSAGE_READ")
                .putExtra("conversation_id", thisConversationId)
                .setPackage("com.example.jogimuc.myapplication");

        PendingIntent msgReadPendingIntent =
                PendingIntent.getBroadcast(c,
                        thisConversationId,
                        msgReadIntent,
                        PendingIntent.FLAG_UPDATE_CURRENT);



        Intent msgReplyIntent = new Intent()
                .addFlags(Intent.FLAG_INCLUDE_STOPPED_PACKAGES)
                .setAction("com.myapp.android.messagingservice.MY_ACTION_MESSAGE_REPLY")
                .putExtra("conversation_id", thisConversationId)
                .setPackage("com.example.jogimuc.myapplication");

        PendingIntent msgReplyPendingIntent = PendingIntent.getBroadcast(
                c,
                thisConversationId,
                msgReplyIntent,
                PendingIntent.FLAG_UPDATE_CURRENT);


        RemoteInput remoteInput;
        NotificationCompat.CarExtender.UnreadConversation.Builder unreadConvBuilder =
                new NotificationCompat.CarExtender.UnreadConversation.Builder(title)
                        .setReadPendingIntent(msgReadPendingIntent)
                        //.setReplyAction(msgReplyPendingIntent, remoteInput)
                        ;


        unreadConvBuilder.addMessage(message);


        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(c)
                        .setSmallIcon(R.mipmap.ic_launcher)
                        //.setLargeIcon(largeIconBitmap)
                        ;


        mBuilder.extend(new NotificationCompat.CarExtender()
                .setUnreadConversation(unreadConvBuilder.build()));


        NotificationManagerCompat msgNotificationManager = NotificationManagerCompat.from(c);
        msgNotificationManager.notify(1, mBuilder.build());

    }

}
