unit mainmodule;

interface

uses
  System.SysUtils,
  System.Classes,
  System.Android.Service,
  AndroidApi.JNI.GraphicsContentViewText,
  Androidapi.JNI.Os;

type
  TDM = class(TAndroidService)
    function AndroidServiceHandleMessage(const Sender: TObject;
      const AMessage: JMessage): Boolean;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DM: TDM;

implementation

{%CLASSGROUP 'FMX.Controls.TControl'}

{$R *.dfm}
uses
  Androidapi.Helpers,
  Androidapi.JNI.JavaTypes,
  Androidapi.JNI.Widget;

function TDM.AndroidServiceHandleMessage(const Sender: TObject;
  const AMessage: JMessage): Boolean;
const
  GET_STRING = 123;
  SERVICE_STRING = 321;
var
  LMessage: JMessage;
  LBundle: JBundle;
begin
  case AMessage.what of
    GET_STRING:
    begin
      LBundle := TJBundle.Create;  // we can not send String because is not parcelable
      LMessage := TJMessage.Create;
      LMessage.what := SERVICE_STRING;
      LBundle.putString(TAndroidHelper.StringToJString('Key'), TAndroidHelper.StringToJString('This is a service text !!!'));
      LMessage.obj := LBundle;
      AMessage.replyTo.send(LMessage);
      Result := True;
    end;
  else
    Result := False;
  end;

end;

end.
