package helperclasses;

import helperclasses.StatusCheck.StateMP;

import java.io.IOException;

import lists.SoundList;
import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaPlayer.OnCompletionListener;
import android.media.SoundPool;
import android.media.SoundPool.OnLoadCompleteListener;
import android.util.Log;
import cs16.tacticalguns.GamePlay;

public class MediaPlayerService {

	    public static MediaPlayer mediaPlayer;
	    private static SoundPool soundPool;
	    public static boolean isplayingAudio = false;
	    static int soundID;
	    public static boolean loaded = false;
	    public static Context context;

	    public MediaPlayerService(Context context) {
	    	
	        MediaPlayerService.context = context;
	    }
	     
	    
//	    LOAD MEDIAPLAYER
		public static void loadAudioToMediaPlayer(int id) {
			
	    	soundID = id;
			mediaPlayer = MediaPlayer.create(context, SoundList.soundListfire.get(id));
	    }
	    
//		LOAD SOUNDPOOL 
	    @SuppressWarnings("deprecation")
		public static void loadAudioToSoundPool(int id) {
	    	
	    	soundPool = new SoundPool(4, AudioManager.STREAM_MUSIC, 100);	
	    	
	        soundPool.setOnLoadCompleteListener(new OnLoadCompleteListener() {
	    	      @Override
	    	      public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
	    	        loaded = true;
	    	      }
	    	});
	        soundID = soundPool.load(context, SoundList.soundListfire.get(id), 1);
		}
	    
//	    PLAY MEDIAPLAYER
	    public static void playAudioFromMediaPlayer() {
	    	    
	    	if(soundID == 28) {
	    		
	    		prepareMP();
	    		GamePlay.statusCheck.mMPState = StateMP.Playing;
	    		
	    		mediaPlayer.setOnCompletionListener(new OnCompletionListener() {
					
					@Override
					public void onCompletion(MediaPlayer mp) {
						GamePlay.statusCheck.mMPState = StateMP.Stopped;		
					}
				});
	    	}
	    	
	    	else if(soundID == 29 && mediaPlayer.isPlaying() == true) {
	    		stopMediaPlayer();
	    		prepareMP();
	    	}
	    	
	    	else if (soundID == 29 && mediaPlayer.isPlaying() == false) {	    		
	    		releaseMediaPlayer();
//	    		Toast.makeText(context, "Bomb is not planted", Toast.LENGTH_LONG).show();
	    	}
	    	else {
	    		prepareMP();
	    	}
	    }
	    
//	    PLAY SOUNDPOOL
	    public static void playAudioFromSoundPool() {
	    	
	    	if(loaded) {
	    		soundPool.play(soundID, 1, 1, 0, 0, 1);
	    	}
	    }
	    
	    public static boolean isMediaPlayerPlaying() {
	        if (GamePlay.statusCheck.mMPState.equals(StateMP.Playing)) {
	            return true;
	        }
	        return false;
	    }
	    
	    public static void stopMediaPlayer() {
	    	if(mediaPlayer.isPlaying()) {
	    		Log.e("+++++++++", "Mediaplayer is playing");
	    		mediaPlayer.stop();
	    		GamePlay.statusCheck.mMPState = StateMP.Stopped;
	    	}
	    	else {
	    		Log.e("+++++++++", "Mediaplayer is not playing!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
	    	}
	    }
	    
	    public static void prepareMP() {
	    	try {
				mediaPlayer.prepare();
			} catch (IllegalStateException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
	    	mediaPlayer.start();
	    }
	    
	    public static void releaseMediaPlayer() {
			if(mediaPlayer != null || mediaPlayer.isPlaying()) {	
				mediaPlayer.stop();
				mediaPlayer.release();
				mediaPlayer = null;
				GamePlay.statusCheck.mMPState = StateMP.Stopped;
			}
		}		
	    
	    public void releaseSoundPool() {
	    	
	    }
}
