package cs16.tacticalguns;

import helperclasses.MediaPlayerService;
import helperclasses.StatusCheck;
import lists.WeaponList;
import adapter.ExpandableListAdapter;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ExpandableListView;
import android.widget.ExpandableListView.OnChildClickListener;

public class MainActivity extends Activity {

	ExpandableListAdapter listAdapter;
    ExpandableListView expListView;  
    WeaponList listData = new WeaponList();
    MediaPlayerService playerService = new MediaPlayerService(this);
    public static StatusCheck checkBombStatus = new StatusCheck();
    String weapon = null;
    Intent openGameplay;
    
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);  
        setContentView(R.layout.main);
        
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
         
        // get the listview
        expListView = (ExpandableListView) findViewById(R.id.expandableListView1);
 
        // preparing list data
        listData.prepareWeaponList();
 
        listAdapter = new ExpandableListAdapter(this, listData.listDataHeader, listData.listDataChild);
 
        // setting list adapter
        expListView.setAdapter(listAdapter);
        
		//collapse all child-items from the listview
        collapseItems();
        
        // Listview on child click listener       
        expListView.setOnChildClickListener(new OnChildClickListener() {
			
			@Override
			public boolean onChildClick(ExpandableListView parent, View v,
										int groupPosition, int childPosition, long id) {
				weapon = listData.listDataChild.get(listData.listDataHeader.get(groupPosition)).get(childPosition);
				
				openGameplay = new Intent(getApplicationContext(), GamePlay.class);
				openGameplay.putExtra("weapon", weapon);
		    	startActivity(openGameplay);
				
				return false;
			}
		});
    }
       
    private void collapseItems() {

    	expListView.expandGroup(0);
    	expListView.expandGroup(1);
    	expListView.expandGroup(2);
    	expListView.expandGroup(3);
    	expListView.expandGroup(4);
    	expListView.expandGroup(5);
    	expListView.expandGroup(6);
    	expListView.expandGroup(7);
    }
    
    
//	---------------------------------#########################---------------------------------
	
	//beende applikation
	public void exitApplication() {
		this.finish();
	}

	
//	---------------------------------#########################---------------------------------

	
	//beende applikation durch return-Taste des gerts
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		//falls die anwendung ber den back-button geschlossen werden soll
		if (keyCode == KeyEvent.KEYCODE_BACK && event.getRepeatCount() == 0) {
	       
	       exitApplication();
	    }
		return super.onKeyDown(keyCode, event);
	}	

	
//	---------------------------------#########################---------------------------------
	
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
	
	@Override
	protected void onDestroy() {
		super.onDestroy();
		Log.e("+++++++++++++++++++++++++", "MAIN - onDestroy");
		
	}


	@Override
	protected void onStart() {
		super.onStart();
		Log.e("+++++++++++++++++++++++++", "MAIN - onStart");
	}


	@Override
	protected void onRestart() {
		super.onRestart();
		Log.e("+++++++++++++++++++++++++", "MAIN - onRestart");
	}


	@Override
	protected void onResume() {
		super.onResume();
		Log.e("+++++++++++++++++++++++++", "MAIN - onResume");
	}


	@Override
	protected void onPause() {
		super.onPause();
		Log.e("+++++++++++++++++++++++++", "MAIN - onPause");
	}


	@Override
	protected void onStop() {
		super.onStop();
		Log.e("+++++++++++++++++++++++++", "MAIN - onStop");
	}
}