package adapter;

import java.util.HashMap;
import java.util.List;

import cs16.tacticalguns.R;
import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class ExpandableListAdapter extends BaseExpandableListAdapter {

	private Context context;
	private List<String> list_titel;
	private HashMap<String, List<String>> list_unterpunkte;
	
//	Konstruktor	
	public ExpandableListAdapter(Context context, List<String> list_titel, HashMap<String, List<String>> 
								list_unterpunkte) {
		super();
		this.context = context;
		this.list_titel = list_titel;
		this.list_unterpunkte = list_unterpunkte;
	}

	@Override
	public int getGroupCount() {
	
		return this.list_titel.size();
	}

	@Override
	public int getChildrenCount(int groupPosition) {
	
		return this.list_unterpunkte.get(this.list_titel.get(groupPosition))
                .size();
	}

	@Override
	public Object getGroup(int groupPosition) {
		
		return this.list_titel.get(groupPosition);
	}

	@Override
	public Object getChild(int groupPosition, int childPosition) {
		
		return this.list_unterpunkte.get(this.list_titel.get(groupPosition)).get(childPosition);
		
	}

	@Override
	public long getGroupId(int groupPosition) {
		
		return groupPosition;
	}

	@Override
	public long getChildId(int groupPosition, int childPosition) {
	
		return childPosition;
	}

	@Override
	public boolean hasStableIds() {
		
		return false;
	}

	@Override
	public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
		
		String headerTitle = (String) getGroup(groupPosition);
        if (convertView == null) {
            LayoutInflater infalInflater = (LayoutInflater) this.context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            convertView = infalInflater.inflate(R.layout.list_group, null);
        }
 
        TextView lblListHeader = (TextView) convertView.findViewById(R.id.tv_header);
        lblListHeader.setTypeface(null, Typeface.BOLD);
        lblListHeader.setText(headerTitle);
 
        return convertView;
	}

	@Override
	public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
		
		final String childText = (String) getChild(groupPosition, childPosition);
		
		 
        if (convertView == null) {
            LayoutInflater infalInflater = (LayoutInflater) this.context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            convertView = infalInflater.inflate(R.layout.list_item, null);
        }
 
        ImageView gunImageListChild = (ImageView) convertView.findViewById(R.id.thumbnail);
        TextView txtListChild = (TextView) convertView.findViewById(R.id.tv_child);

        if(groupPosition == 0) {
            if(childPosition == 0) gunImageListChild.setImageResource(R.drawable.iknife);
	    }
	    else if(groupPosition == 1) {
	    	if(childPosition == 0) gunImageListChild.setImageResource(R.drawable.iusp);
	    	if(childPosition == 1) gunImageListChild.setImageResource(R.drawable.iglock);
	    	if(childPosition == 2) gunImageListChild.setImageResource(R.drawable.ip228);
	    	if(childPosition == 3) gunImageListChild.setImageResource(R.drawable.ifive);
	    	if(childPosition == 4) gunImageListChild.setImageResource(R.drawable.idesert);
	    	if(childPosition == 5) gunImageListChild.setImageResource(R.drawable.idual);
	    }
	    else if(groupPosition == 2) {
	    	if(childPosition == 0) gunImageListChild.setImageResource(R.drawable.itmp);
	    	if(childPosition == 1) gunImageListChild.setImageResource(R.drawable.imac);
	    	if(childPosition == 2) gunImageListChild.setImageResource(R.drawable.imp5);
	    	if(childPosition == 3) gunImageListChild.setImageResource(R.drawable.iump);
	    	if(childPosition == 4) gunImageListChild.setImageResource(R.drawable.ip90);
	    }
	    else if(groupPosition == 3) {
	    	if(childPosition == 0) gunImageListChild.setImageResource(R.drawable.igalil);
	    	if(childPosition == 1) gunImageListChild.setImageResource(R.drawable.iak47);
	    	if(childPosition == 2) gunImageListChild.setImageResource(R.drawable.isg552);
	    	if(childPosition == 3) gunImageListChild.setImageResource(R.drawable.ifamas);
	    	if(childPosition == 4) gunImageListChild.setImageResource(R.drawable.im4a1);
	    	if(childPosition == 5) gunImageListChild.setImageResource(R.drawable.iaug);
	    }
	    else if(groupPosition == 4) {
	    	if(childPosition == 0) gunImageListChild.setImageResource(R.drawable.isg550);
	    	if(childPosition == 1) gunImageListChild.setImageResource(R.drawable.iscout);
	    	if(childPosition == 2) gunImageListChild.setImageResource(R.drawable.id3);
	    	if(childPosition == 3) gunImageListChild.setImageResource(R.drawable.iawp);
	    }
	    else if(groupPosition == 5) {
	    	if(childPosition == 0) gunImageListChild.setImageResource(R.drawable.im249);
	    }
	    else if(groupPosition == 6) {
	    	if(childPosition == 0) gunImageListChild.setImageResource(R.drawable.im3);
	    	if(childPosition == 1) gunImageListChild.setImageResource(R.drawable.im4);
	    }
	    else if(groupPosition == 7) {
	    	if(childPosition == 0) gunImageListChild.setImageResource(R.drawable.igflash);
	    	if(childPosition == 1) gunImageListChild.setImageResource(R.drawable.ighumo);
	    	if(childPosition == 2) gunImageListChild.setImageResource(R.drawable.ighe);
	    	if(childPosition == 3) gunImageListChild.setImageResource(R.drawable.ic4);
	    	if(childPosition == 4) gunImageListChild.setImageResource(R.drawable.idefusal);
	    }
        
        txtListChild.setText(childText);
        return convertView;
	}

	@Override
	public boolean isChildSelectable(int groupPosition, int childPosition) {
		
		return true;
	}	

}
