package cs16.tacticalguns;

import helperclasses.MediaPlayerService;
import helperclasses.StatusCheck;
import helperclasses.StatusCheck.StateBomb;
import lists.SoundList;
import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

public class GamePlay extends Activity {
	
	ImageView imageView;
	TextView total_ammo, current_ammo, weapon_art;
	ImageButton reload;
	String weapon;
	SoundList soundList = new SoundList();
	int i = 0;
	private static int soundID;
	int j = 0;
	static boolean loaded = false;
	public static StatusCheck statusCheck = new StatusCheck();

	
//	#############################################################################################
//	onCreate
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.gameplay);
		
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
		
//		init layout
		imageView    = (ImageView) findViewById(R.id.imageView1);
		total_ammo   = (TextView) findViewById(R.id.textView_totalAmo);
		current_ammo = (TextView) findViewById(R.id.textView_currentAmo);
		weapon_art   = (TextView) findViewById(R.id.textView_weaponArt);
		reload       = (ImageButton) findViewById(R.id.imageButton_reload);
				
//		get Weapon-art from MainActivity
		Bundle extras = getIntent().getExtras();		

//		init sound
		soundList.prepareSoundData();
		
//		load grafik
		loadweapon(weapon = extras.getString("weapon"));
	
//		load sound
		loadsound();
		
///		Aktion: Klick auf das Bild lst sound aus + current_Amo wird aktualisert.
		imageView.setOnClickListener(new OnClickListener() {
						
			@Override
			public void onClick(View v) {
				
//				if(CheckBombStatus.mState == State.Bomb_planted && MediaPlayerService.isMediaPlayerPlaying() == false) {
//					CheckBombStatus.mState = State.Bomb_notPlanted;
//				}
				
//				j checks if knife, grenates or bomb is choosen -> take mediaplayer for sounds, else soundpool
				if(j == 1) {
					
					if(soundID == 28 && statusCheck.mBombState == StateBomb.Bomb_notPlanted) {
						statusCheck.mBombState = StateBomb.Bomb_planted;
						MediaPlayerService.playAudioFromMediaPlayer();
					}
					else if(soundID == 28 && statusCheck.mBombState == StateBomb.Bomb_planted) {
						Toast.makeText(getApplicationContext(), "Bomb is already planted!", Toast.LENGTH_SHORT).show();
					}
					
					else if(soundID == 29 && statusCheck.mBombState == StateBomb.Bomb_notPlanted) {
						Toast.makeText(getApplicationContext(), "Bomb is not planted!", Toast.LENGTH_SHORT).show();
					}				
					else if(soundID == 29 && statusCheck.mBombState == StateBomb.Bomb_planted) {
						MediaPlayerService.stopMediaPlayer();
//						MediaPlayerService.loadAudioToMediaPlayer(soundID);
						MediaPlayerService.playAudioFromMediaPlayer();
					}
					else {
						MediaPlayerService.playAudioFromMediaPlayer();
					}
				}
				
				if(i > 0 && j == 0) {

					i = i - 1;
					MediaPlayerService.playAudioFromSoundPool();
					current_ammo.setText("" + i);
				}
				else if (i == 0 && j == 0){
//					Toast.makeText(getApplicationContext(), "You have to reload!", Toast.LENGTH_SHORT).show();
//					MediaPlayerService.loadAudioToSoundPool(getApplicationContext(), 54);
				}
			}
		});
		
//		Aktion: Klick auf Reload soll Status current_Amo zurcksetzen;
		reload.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				current_ammo.setText("" +  total_ammo.getText().toString());
				i = Integer.valueOf(current_ammo.getText().toString());
			}
		});
	}
	
	
//	---------------------------------#########################---------------------------------
//	---------------------------------#########################---------------------------------
	
	private void loadweapon(String weapon) {
				
		if(weapon.equals("Messer")) {
			
			soundID = 0;
			j = 1;
			
			imageView.setImageResource(R.drawable.knife1);
			setDisplayViewsToInvisible();
		}
		
		else if(weapon.equals("USP .45 ACP Tactical")) {
			
			soundID = 1;
			
			imageView.setImageResource(R.drawable.usp45);
			i = 12;
			updateAmmo();
		}
		
		else if(weapon.equals("Glock 18C Select Fire")) {
			
			soundID = 2;
			
			imageView.setImageResource(R.drawable.glock18);
			i = 20;
			updateAmmo();
		}
		
		else if(weapon.equals("SIG P228")) {
			
			soundID = 3;
			
			imageView.setImageResource(R.drawable.p228);
			i = 13;
			updateAmmo();
		}
				
		else if(weapon.equals("Five-Seven")) {
			
			soundID = 4;
			
			imageView.setImageResource(R.drawable.fiveseven);
			i = 20;
			updateAmmo();
		}
				
		else if(weapon.equals("Desert Eagle .50 AE")) {
			
			soundID = 5;
			
			imageView.setImageResource(R.drawable.deserteagle);
			i = 7;
			updateAmmo();
		}
				
		else if(weapon.equals("Dual 96G Elite Baretta")) {
			
			soundID = 6;
			
			imageView.setImageResource(R.drawable.elites);
			i = 30;
			updateAmmo();
		}
				
		else if(weapon.equals("TMP")) {
			
			soundID = 7;
			
			imageView.setImageResource(R.drawable.tmp);
			i = 30;
			updateAmmo();
		}
				
		else if(weapon.equals("Ingram MAC-10")) {
			
			soundID = 8;
			
			imageView.setImageResource(R.drawable.mac10);
			i = 30;
			updateAmmo();
		}
				
		else if(weapon.equals("MP5-A3")) {
			
			soundID = 9;
			
			imageView.setImageResource(R.drawable.mp5);
			i = 30;
			updateAmmo();
		}
				
		else if(weapon.equals("HK UMP")) {
			
			soundID = 10;
			
			imageView.setImageResource(R.drawable.ump45);
			i = 25;
			updateAmmo();
		}
				
		else if(weapon.equals("ES C90/P90")) {
			
			soundID = 11;
			
			imageView.setImageResource(R.drawable.p90);
			i = 50;
			updateAmmo();
		}
				
		else if(weapon.equals("Galil")) {
			
			soundID = 12;
			
			imageView.setImageResource(R.drawable.galil);
			i = 35;
			updateAmmo();
		}
				
		else if(weapon.equals("Ak-47")) {
			
			soundID = 13;
			
			imageView.setImageResource(R.drawable.ak47);
			i = 30;
			updateAmmo();
		}
				
		else if(weapon.equals("SIG 552")) {
			
			soundID = 14;
		
			imageView.setImageResource(R.drawable.sg552);
			i = 30;
			updateAmmo();
		}
				
		else if(weapon.equals("Famas")) {
			
			soundID = 15;
		
			imageView.setImageResource(R.drawable.famas);
			i = 25;
			updateAmmo();
		}
				
		else if(weapon.equals("Model 4 Carabine")) {
			
			soundID = 16;
			
			imageView.setImageResource(R.drawable.m4a1);
			i = 30;
			updateAmmo();
		}
				
		else if(weapon.equals("Steyr AUG A1")) {
			
			soundID = 17;
				
			imageView.setImageResource(R.drawable.aug);
			i = 30;
			updateAmmo();
		}
				
		else if(weapon.equals("SIG SG-550")) {
			
			soundID = 18;
			
			imageView.setImageResource(R.drawable.sg550);
			i = 30;
			updateAmmo();
		}
		
		else if(weapon.equals("Steyr Scout")) {
			
			soundID = 19;
				
			imageView.setImageResource(R.drawable.scout);
			i = 10;
			updateAmmo();	
		}
				
		else if(weapon.equals("H&K G3/SG-1")) {
			
			soundID = 20;
			
			imageView.setImageResource(R.drawable.g3sg1);
			i = 20;
			updateAmmo();
		}
		
		else if(weapon.equals("Arctic Warefare Super Magnum (AWP)")) {
			
			soundID = 21;
			
			imageView.setImageResource(R.drawable.awp);
			i = 10;
			updateAmmo();
		}
		
		else if(weapon.equals("FN M249 Para")) {
			
			soundID = 22;
			
			imageView.setImageResource(R.drawable.m249);
			i = 100;
			updateAmmo();
		}
		
		else if(weapon.equals("Benelli M3")) {
			
			soundID = 23;
			
			imageView.setImageResource(R.drawable.m3);
			i = 8;
			updateAmmo();
		}
				
		else if(weapon.equals("Benelli XM 1014")) {
			
			soundID = 24;
			
			imageView.setImageResource(R.drawable.xm1014);
			i = 7;
			updateAmmo();
		}
		
		else if(weapon.equals("Blendgranate")) {
			
			j = 1;
			soundID = 25;
			
			imageView.setImageResource(R.drawable.flashbang1);
			setDisplayViewsToInvisible();
		}
		
		else if(weapon.equals("Rauchgranate")) {
			
			j = 1;
			soundID = 26;
			
			imageView.setImageResource(R.drawable.smokegrenade2);
			setDisplayViewsToInvisible();
		}
				
		else if(weapon.equals("Sprenggranate")) {
			
			j = 1;
			soundID = 27;
			
			imageView.setImageResource(R.drawable.he_a);
			setDisplayViewsToInvisible();
		}
				
		else if(weapon.equals("C4-Zeitbombe")) {
			
			j = 1;
			imageView.setImageResource(R.drawable.bomb);
			
			soundID = 28;
			setDisplayViewsToInvisible();
			
		}
//				
		else if(weapon.equals("Defuse-Kit")) {
			
			j = 1;
			imageView.setImageResource(R.drawable.defusekit);
			
			soundID = 29;
			setDisplayViewsToInvisible();
		}
	}
	
	
//	---------------------------------#########################---------------------------------
	
	private void updateAmmo() {
		
		total_ammo.setText("" + i);
		current_ammo.setText("" + i);
	}

	
//	---------------------------------#########################---------------------------------
	
	private void loadsound() {
		if(j == 1) {
			
			MediaPlayerService.loadAudioToMediaPlayer(soundID);
		}
//		else if(current_ammo.getText().equals(0)) {
//			MediaPlayerService.loadAudioToMediaPlayer(this, (soundID));
//		}
		else {
			
			MediaPlayerService.loadAudioToSoundPool(soundID);
		}
	}

	
//	---------------------------------#########################---------------------------------
	
	private void setDisplayViewsToInvisible() {
		reload.setVisibility(View.INVISIBLE);
		total_ammo.setVisibility(View.INVISIBLE);
		current_ammo.setVisibility(View.INVISIBLE);
	}
	
//	---------------------------------#########################---------------------------------
	
	@Override
	protected void onDestroy() {
		super.onDestroy();
		Log.e("+++++++++++++++++++++++++", "Game - onDestroy");
		
	}


	@Override
	protected void onStart() {
		super.onStart();
		Log.e("+++++++++++++++++++++++++", "Game - onStart");
	}


	@Override
	protected void onRestart() {
		super.onRestart();
		Log.e("+++++++++++++++++++++++++", "Game - onRestart");
	}


	@Override
	protected void onResume() {
		super.onResume();
		Log.e("+++++++++++++++++++++++++", "Game - onResume");
	}


	@Override
	protected void onPause() {
		super.onPause();
		Log.e("+++++++++++++++++++++++++", "Game - onPause");
	}


	@Override
	protected void onStop() {
		super.onStop();
		Log.e("+++++++++++++++++++++++++", "Game - onStop");
	}
}