package dev.mrunknow.slidedirection;

import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.view.MotionEvent;
import android.widget.LinearLayout;
import android.widget.TextView;

public class SlideDirection extends Activity {
    /** Called when the activity is first created. */

	private LinearLayout main;      
    private TextView viewA;
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        main = new LinearLayout(this);  
        main.setBackgroundColor(Color.BLACK);  
        main.setLayoutParams(new LinearLayout.LayoutParams(320,480));  

        viewA = new TextView(this);  
        viewA.setBackgroundColor(Color.WHITE);  
        viewA.setTextColor(Color.BLACK);  
        viewA.setTextSize(15);
        viewA.setLayoutParams(new LinearLayout.LayoutParams(320,180));  
        viewA.setText("SlideDirection v1.0 \nCode: Mr_Unknow \n\nThis app show you the slidedirection. \n\nVisit: \n[DE] android-hilfe.de \n[EN] anddev.org \n[DE] android-developers.de");
        main.addView(viewA);
        setContentView(main);
    }
	
	float x_start = 0, y_start = 0, x_end = 0, y_end = 0;
	
	@Override
    public boolean onTouchEvent(MotionEvent event) {
		viewA.setText("");
		viewA.setLayoutParams(new LinearLayout.LayoutParams(320,80));
		viewA.setTextSize(40);
		
        int action = event.getAction();
        
        if (action == MotionEvent.ACTION_DOWN)
        {
        	x_start = event.getX();
            y_start = event.getY();
        }
 
        if(action == MotionEvent.ACTION_UP)
        {
        	x_end = event.getX();
        	y_end = event.getY();
        	
        	if((x_start - x_end) > 75)
        	{
        		viewA.setText("LEFT");
        	}
        	if((x_start - x_end) < -75)
        	{
        		viewA.setText("RIGHT");
        	}
        	if((y_start - y_end) > 75)
        	{
        		viewA.setText("TOP");
        	}
        	if((y_start - y_end) < -75)
        	{
        		viewA.setText("BOTTOM");
        	}
        	if((x_start - x_end) > 75 && (y_start - y_end) > 75)
        	{
        		viewA.setText("LEFT - TOP");
        	}
        	if((x_start - x_end) > 75 && (y_start - y_end) < -75)
        	{
        		viewA.setText("LEFT - BOTTOM");
        	}
        	if((x_start - x_end) < -75 && (y_start - y_end) > 75)
        	{
        		viewA.setText("RIGHT - TOP");
        	}
        	if((x_start - x_end) < -75 && (y_start - y_end) < -75)
        	{
        		viewA.setText("RIGHT - BOTTOM");
        	}
        }
        return true;
    }
}