package com.example.servicedemo.services;

// Another lot of imports
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;

public class RandomValueService extends Service {
	// We need some instance variables as well.
	private final RandomValueService.RandomValueBinder binder = new RandomValueBinder();
	private RandomValueCallback callback;
	private ScheduledExecutorService scheduledTaskExecutor;
	
	/* A specified class of the Binder which returns a specified service. 
	 * Saves a lot of casting stuff later on.
	*/
	public class RandomValueBinder extends Binder {
		public RandomValueService getService() {
			return RandomValueService.this;
		}
	}
	
	// onBind method is called EVERY TIME an activity binds to the service!
	/* Keep in mind that this implementation will render unfunctional as soon as different 
	 * activity bind to or unbind from this service. I've just created it for ONE accessing activity!
	 */
	@Override
	public RandomValueService.RandomValueBinder onBind(Intent intent) {
		scheduledTaskExecutor = Executors.newScheduledThreadPool(2);
		scheduledTaskExecutor.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
				postNewValue();
			}
		}, 2, 10, TimeUnit.SECONDS);
		return binder;
	}

	// onUnbind method is called EVERY TIME an activity unbinds!
	@Override
	public boolean onUnbind(Intent intent) {
		scheduledTaskExecutor.shutdownNow();
		return false;
	}
	
	// Our own method which sets the callback.
	public void setCallbackListener(RandomValueCallback listener) {
		callback = listener;
	}
	
	// The method informing the callback about changes.
	private void postNewValue() {
		// since callback could be null and we don't want any NullPointerExceptions: check it first!
		if(callback != null) {
			callback.didGatherNewStringValue(binder, getPseudoValueString());
		}
	}
	
	// Public method which creates a pseudo value string (like your controller could.)
	public String getPseudoValueString() {
		String resultString = "$";
		resultString += appendingSegmentsOfAmount(4);
		return resultString;
	}
	
	// Generating <amount> strings of type "(-)0-255:"
	private String appendingSegmentsOfAmount(int amount) {
		String resultString = "";
		for(int i = 0; i < 4; i++) {
			resultString += getRandomMinusSign();
			resultString += getIntegerValue();
			resultString += ":";
		}
		return resultString;
	}
	
	// Randomly returns a - sign.
	private String getRandomMinusSign() {
		Random random = new Random();
		return (random.nextInt(19) >= 18) ? "-" : "";
	}

	// Returns an integer from 0 to 255
	private Integer getIntegerValue() {
		Random random = new Random();
		return random.nextInt(255);
	}
}
