package de.androidnewcomer.myserialreaderservice2;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;


public class MainActivity extends Activity implements OnClickListener {
	
  private static final String TAG = "ServicesDemo";
  
  Button buttonStart, buttonStop;
  private TextView textView;
  
  
  
  private EreignisHandler ereignisHandler = new EreignisHandler();
  
	private class EreignisHandler extends Handler {
		@Override
		public void handleMessage(Message msg) {
			textView.setText(Integer.toString(msg.what));
			//textView.setText(msg);
			//textView.append(msg);
		}
	}
	

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.main);

    buttonStart = (Button) findViewById(R.id.buttonStart);
    buttonStop = (Button) findViewById(R.id.buttonStop);

    buttonStart.setOnClickListener(this);     
    buttonStop.setOnClickListener(this);
    
    textView = (TextView) findViewById(R.id.reader);
  }
  
  @Override
  protected void onResume() {
  	super.onResume();
  	MyReaderService.ereignisHandler = ereignisHandler;
  	textView.setText(Integer.toString(MyReaderService.schritte)); // should be reader
  }
  
  @Override
  protected void onPause() {
  	super.onPause();
  }
  

  public void onClick(View src) {
    switch (src.getId()) {
    case R.id.buttonStart:
      Log.d(TAG, "onClick: starting srvice");
      startService(new Intent(this, MyReaderService.class));
      MyReaderService.ereignisHandler = ereignisHandler;
    break;
    case R.id.buttonStop:
      Log.d(TAG, "onClick: stopping srvice");
      stopService(new Intent(this, MyReaderService.class));
      break;
    }
  }
}
