/*
 *  dd. 04.12.2013 Mittwoch
 *  name: SerialReader
 *  (no writeButton, no EditText, only ScrolledView and TextView)
 *  - compile ok
 *  - 1. run probleme aber nach einigen hickhacks
 *    - 1.mal only serialReader OK
 *    - 2.mal ohne vorherige Lite or SerialCom2
 *      - run with serialReader  OOOK
 *05.12. notes:
 *       - Research and Developments (36)
 *         - 1) 1.OnlineTest
 *              - als 1.gestartet Run OOK
 *         - 2) SerialReader (2)       
 *              - 1) Umbauten (1):
 *                   - LOG raus OK
 *              - 2) Convert - stringTokens into integer TokValues
 *                   - 1) 1. Version of Tokenizer (old Version)
 *                        - 1) einbau  yes
 *                        - 2) compile yes
 *                        - 3) upload  yes
 *                        - 4) onlineTest:
 *                             - NOK Tablet Absturz
 *                   - 2) 2.Versuch
 *                        in forloop only tokens[i]
 *                        then direkte zuweisung on loop
 *                        - Wieder NOK
 *                   - 3) Orig. ok erweiterungen NOK
 *                        WHY   
 * also ca. 14.45 teilweise ok
 *                - abbruch aber es wird verarbeitet...
 *                  - IntArray into 4x HeadTrackerValues
 *                    - ist moeglich....-
 *
 * notes. 06.12. 
 *        - ev.fehler gefunden
 *          - tokens.length = unterschiedliche werte zwischen 3,5,4,6
 *          
 *                    
 *         - 3) Testings
 *              -
 *         - 4) Versuch Einbau SerialRead + glStereo
      
 *      
 *  
 */


package de.androidnewcomer.serialreader;

import java.io.IOException;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Typeface;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

import com.physicaloid.lib.Physicaloid;
import com.physicaloid.lib.usb.driver.uart.UartConfig;
// import android.util.Log;

public class MainActivity extends Activity {
	
	boolean dtrOn=false;
	boolean rtsOn=false;
	
	boolean  boolSetConfig = false;
	boolean  boolOpenCom   = false;
	
	// 1.Versuch vars global ???
    String myStr;
    String delims = "[$:]+";
    String[] tokens;
    
    int mylen = 0;
	 
	int i=0;
	int tokArr[] = { 0,0,0,0};
	int gx, gy, gz = 0;
	int compass = 0;


	// occurs USB packet loss if TEXT_MAX_SIZE is over 6000
    private static final int TEXT_MAX_SIZE = 8192;
    
 // Defines of Display Settings
    private static final int DISP_CHAR  = 0;
    private static final int DISP_DEC   = 1;
    private static final int DISP_HEX   = 2;

    // Linefeed Code Settings
    private static final int LINEFEED_CODE_CR   = 0;
    private static final int LINEFEED_CODE_CRLF = 1;
    private static final int LINEFEED_CODE_LF   = 2; 
    
    Physicaloid mSerial;

    private ScrollView mSvText;
    private TextView mTvSerial;
    StringBuilder mText = new StringBuilder();
  //  private StringBuilder in = new StringBuilder();
    //in = mText;
  //  StringTokenizer st = new StringTokenizer(in, "$:");
	
    private boolean mStop = false;

    String TAG = "AndroidSerialTerminal";
    
    Handler mHandler = new Handler();

    // Default settings
    private int mTextFontSize       = 12;
    private Typeface mTextTypeface  = Typeface.MONOSPACE;
    private int mDisplayType        = DISP_CHAR;
    private int mReadLinefeedCode   = LINEFEED_CODE_LF;
    private int mWriteLinefeedCode  = LINEFEED_CODE_LF;
    private int mBaudrate           = 9600;
    private int mDataBits           = UartConfig.DATA_BITS8;
    private int mParity             = UartConfig.PARITY_NONE;
    private int mStopBits           = UartConfig.STOP_BITS1;
    private int mFlowControl        = UartConfig.FLOW_CONTROL_OFF;
    private String mEmailAddress    = "@gmail.com";

    private boolean mRunningMainLoop = false;

    private static final String ACTION_USB_PERMISSION =
            "de.androidnewcomer.serialcom.USB_PERMISSION";
    
    // Linefeed
    private final static String BR = System.getProperty("line.separator");
    
    @Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		setContentView(R.layout.main);
		
		Toast.makeText(this, "onCreate No.1", Toast.LENGTH_SHORT).show();
		
		mSvText = (ScrollView) findViewById(R.id.svText);
        mTvSerial = (TextView) findViewById(R.id.tvSerial);
    
        Toast.makeText(this, "New FTDriver", Toast.LENGTH_SHORT).show();      

        // get service
        mSerial = new Physicaloid(this);

        Toast.makeText(this, "New Instance: " + mSerial, Toast.LENGTH_SHORT).show();        
      
        // listen for new devices
        IntentFilter filter = new IntentFilter();
        filter.addAction(UsbManager.ACTION_USB_DEVICE_ATTACHED);
        filter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
        
        // on Lite line 744 
        // BroadcastReceiver mUsbReceiver = new BroadcastReceiver() 
        // war fehler:
        registerReceiver(mUsbReceiver, filter);
       
        Toast.makeText(this, "OnCreate No.2 - FTDriver beginning", Toast.LENGTH_SHORT).show();
        
        // zuerst von SerialCom line 560
        // 1.Versuch: SerialCom Settings
        // from baseSetting.txt folder Lite
        mBaudrate = 9600;
        mSerial.setBaudrate(mBaudrate);				 
        				 
        mDataBits =	UartConfig.DATA_BITS8;
        mSerial.setDataBits(mDataBits);				 
        				 
        mParity = UartConfig.PARITY_NONE;
        mSerial.setParity(mParity);
        
        mStopBits = UartConfig.STOP_BITS1;
        mSerial.setStopBits(mStopBits);	
        
        mStopBits = UartConfig.STOP_BITS1;
        mSerial.setStopBits(mStopBits);			 
        
        dtrOn = false;
        rtsOn = false;
        mFlowControl = UartConfig.FLOW_CONTROL_OFF;
        mSerial.setDtrRts(false, false);  
        if(mFlowControl == UartConfig.FLOW_CONTROL_OFF) {
        	dtrOn = false;
            rtsOn = false;
        }
        
        mSerial.setConfig(new UartConfig(mBaudrate, mDataBits, mStopBits, mParity, dtrOn, rtsOn));
        
        // i.A. keine Abfrage moeglich ob SetConfig OK
        boolSetConfig = true;
        
        if(boolSetConfig == true) {
        	Toast.makeText(this, "setConfig : baud : "+mBaudrate+", DataBits : "+mDataBits+", StopBits : "+mStopBits+", Parity : "+mParity+", dtr : "+dtrOn+", rts : "+rtsOn,Toast.LENGTH_SHORT).show();
        }
        
        Toast.makeText(this, "setConfigOK", Toast.LENGTH_SHORT).show();
	    
        // now: on Lite line 184 openSerial....
        openUsbSerial();
        Toast.makeText(this, "OpenUSB-Serial No.3 OK", Toast.LENGTH_SHORT).show();
    }

    

@Override
public void onDestroy() {
    mSerial.close();
    mStop = true;
    // --> war fehler weiter unter unten mUsbReceiver  
    unregisterReceiver(mUsbReceiver);
    super.onDestroy();
}

private void mainloop() {
    mStop = false;
    mRunningMainLoop = true;
    Toast.makeText(this, "Connected MainLoop No 5", Toast.LENGTH_SHORT).show();
     
    new Thread(mLoop).start();
}

private Runnable mLoop = new Runnable() {
    @Override
    public void run() {
        int len;
        byte[] rbuf = new byte[4096];
        
        for (;;) {// this is the main loop for transferring

            // ////////////////////////////////////////////////////////
            // Read and Display to Terminal
            // ////////////////////////////////////////////////////////
        	        	
            len = mSerial.read(rbuf);
            rbuf[len] = 0;

            if (len > 0) {
            	 //Log.d(TAG, "Read  Length : " + len);
                
                switch (mDisplayType) {
                    case DISP_CHAR:
                    setSerialDataToTextView(mDisplayType, rbuf, len, "", "");
                    break;
                case DISP_DEC:
                    setSerialDataToTextView(mDisplayType, rbuf, len, "013", "010");
                    break;
                case DISP_HEX:
                    setSerialDataToTextView(mDisplayType, rbuf, len, "0d", "0a");
                    break;
            }

            mHandler.post(new Runnable() {     
            	public void run() {
                    if (mTvSerial.length() > TEXT_MAX_SIZE) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(mTvSerial.getText());
                        sb.delete(0, TEXT_MAX_SIZE / 2);
                        mTvSerial.setText(sb);
                        
                    }
                     
                    // This is OK running
                //    mTvSerial.append(mText);
                    myStr = mText.toString();
                    delims = "[$:]+";
                    tokens = myStr.split(delims);
                    
                    mylen = tokens.length;
                    
                    mTvSerial.append("Len: "+tokens.length);
                    
                    for(int i = 0; i < tokens.length; i++)
                    {
                        // show string Tok
                    	mTvSerial.append("Tok: "+tokens[i]);
                    	
                    } 
                    
                    mTvSerial.append("Tok 0:" +tokens[0]+ ",Tok 1: "+tokens[1]+", Tok 2: "+tokens[2]+", Tok 3: "+tokens[3]);
                 /*   
                    int j = 0;
                    for(j = 0; j < mylen; j++)
                    {
                    	// mTvSerial.append("for: "+j);
                    	
                    	try {
                    		tokArr[j] = Integer.parseInt(tokens[j]);
                    	}catch (NumberFormatException nfe)
                    	{
                  //  		nfe.printStackTrace();
                    	}
                    	
                        if(j==0) gx = tokArr[0];
                        if(j==1) gy = tokArr[1];
                        if(j==2) gz = tokArr[2];
                        if(j==3) compass = tokArr[3];
                        
                    }
                    
                    tokArr[0] = Integer.parseInt(tokens[0]);
                    tokArr[1] = Integer.parseInt(tokens[1]);
                    tokArr[2] = Integer.parseInt(tokens[2]);
                    tokArr[3] = Integer.parseInt(tokens[3]);
                    
                    gx = tokArr[0];
                    gy = tokArr[1];
                    gz = tokArr[2];
                    compass = tokArr[3];
                    
                    mTvSerial.append("GZ:" +gz+ ",GY: "+gy+", GZ: "+gz+", Compass: "+compass);
             //       tokenizer();
                    	
                    // convert from string to integer
                    for(int i = 0; i < tokens.length; i++)
                         tokArr[i] = Integer.parseInt(tokens[i]
                             
                    tokArr[0] = Integer.parseInt(tokens[0]);
                    tokArr[1] = Integer.parseInt(tokens[1]);
                    tokArr[2] = Integer.parseInt(tokens[2]);
                    tokArr[3] = Integer.parseInt(tokens[3]);
                    
                    gx = tokArr[0];
                    gy = tokArr[1];
                    gz = tokArr[2];
                    compass = tokArr[3];
                    */
                    
 
           
                    // mTvSerial.append("gx :"+gx+", gy : "+gy+", gz :"+gz+", compass :"+compass);
                    
                    mTvSerial.append("ParseConvert OK");

                    
                    mText.setLength(0);
                    mSvText.fullScroll(ScrollView.FOCUS_DOWN);
                    
            //        tokenizer();
                   
                    
                }
            });
        }

        try {
            Thread.sleep(50);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        if (mStop) {
            mRunningMainLoop = false;
            return;
        }
    }
}
};
	
// jetzt kommen ev. voellig ueberfluessige functionen
// koennte probleme hervorrufen:
private String IntToHex2(int Value) {
    char HEX2[] = {
            Character.forDigit((Value >> 4) & 0x0F, 16),
            Character.forDigit(Value & 0x0F, 16)
    };
    String Hex2Str = new String(HEX2);
    return Hex2Str;
}

boolean lastDataIs0x0D = false;

void setSerialDataToTextView(int disp, byte[] rbuf, int len, String sCr, String sLf) {
    int tmpbuf;
    for (int i = 0; i < len; ++i) {
        // Log.d(TAG, "Read  Data[" + i + "] : " + rbuf[i]);
        
        // "\r":CR(0x0D) "\n":LF(0x0A)
        if ((mReadLinefeedCode == LINEFEED_CODE_CR) && (rbuf[i] == 0x0D)) {
            mText.append(sCr);
            mText.append(BR);
        } else if ((mReadLinefeedCode == LINEFEED_CODE_LF) && (rbuf[i] == 0x0A)) {
            mText.append(sLf);
            mText.append(BR);
        } else if ((mReadLinefeedCode == LINEFEED_CODE_CRLF) && (rbuf[i] == 0x0D)
                && (rbuf[i + 1] == 0x0A)) {
            mText.append(sCr);
            if (disp != DISP_CHAR) {
                mText.append(" ");
            }
            mText.append(sLf);
            mText.append(BR);
            ++i;
        } else if ((mReadLinefeedCode == LINEFEED_CODE_CRLF) && (rbuf[i] == 0x0D)) {
            // case of rbuf[last] == 0x0D and rbuf[0] == 0x0A
            mText.append(sCr);
            lastDataIs0x0D = true;
        } else if (lastDataIs0x0D && (rbuf[0] == 0x0A)) {
            if (disp != DISP_CHAR) {
                mText.append(" ");
            }
            mText.append(sLf);
            mText.append(BR);
            lastDataIs0x0D = false;
        } else if (lastDataIs0x0D && (i != 0)) {
            // only disable flag
            lastDataIs0x0D = false;
            --i;
        } else {
            switch (disp) {
                case DISP_CHAR:
                    mText.append((char) rbuf[i]);
                    break;
                case DISP_DEC:
                    tmpbuf = rbuf[i];
                    if (tmpbuf < 0) {
                        tmpbuf += 256;
                    }
                    mText.append(String.format("%1$03d", tmpbuf));
                    mText.append(" ");
                    break;
                case DISP_HEX:
                    mText.append(IntToHex2((int) rbuf[i]));
                    mText.append(" ");
                    break;
                default:
                    break;
            }
        }
    }
}

// vorallem own  loadDefaultSettingValues()
// here stuff von own SerialCom einfuegen
void loadDefaultSettingValues() {
	
	Toast.makeText(this, "LoadDefaultSettingValues", Toast.LENGTH_SHORT).show();
	 
    mSerial.setConfig(new UartConfig(mBaudrate, mDataBits, mStopBits, mParity, dtrOn, rtsOn));
	}

// here in orig. 
// 1) sendTextToEmail()
// 2) loadDefaultBaudrate()

private void openUsbSerial() {
    if(mSerial == null) {
        Toast.makeText(this, "cannot open", Toast.LENGTH_SHORT).show();
        return;
    }
    if (!mSerial.isOpened()) {
    	 Toast.makeText(this, "On NewIntent begin", Toast.LENGTH_SHORT).show();
        
        if (!mSerial.open()) {
            Toast.makeText(this, "Cannot open", Toast.LENGTH_SHORT).show();
            return;
        } else {
            loadDefaultSettingValues();

            boolean dtrOn=false;
            boolean rtsOn=false;
            if(mFlowControl == UartConfig.FLOW_CONTROL_ON) {
                dtrOn = true;
                rtsOn = true;
            }
            mSerial.setConfig(new UartConfig(mBaudrate, mDataBits, mStopBits, mParity, dtrOn, rtsOn));

            Toast.makeText(this, "setConfig : baud : "+mBaudrate+", DataBits : "+mDataBits+", StopBits : "+mStopBits+", Parity : "+mParity+", dtr : "+dtrOn+", rts : "+rtsOn,Toast.LENGTH_SHORT).show();
            
            mTvSerial.setTextSize(mTextFontSize);

            Toast.makeText(this, "Connected", Toast.LENGTH_SHORT).show();
        }
    }
    
    if (!mRunningMainLoop) {
    	   Toast.makeText(this, "onMainLoop No.6", Toast.LENGTH_SHORT).show();
    	      
        mainloop();
    }

}

private void closeUsbSerial() {
    detachedUi();
    mStop = true;
    mSerial.close();
}

protected void onNewIntent(Intent intent) {
	 Toast.makeText(this, "On NewIntent", Toast.LENGTH_SHORT).show();
    
     openUsbSerial();
};

private void detachedUi() {
    
    Toast.makeText(this, "Disconnect", Toast.LENGTH_SHORT).show();
}

//BroadcastReceiver when insert/remove the device USB plug into/from a USB
// port
BroadcastReceiver mUsbReceiver = new BroadcastReceiver() {
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();

        if (UsbManager.ACTION_USB_DEVICE_ATTACHED.equals(action)) {
        	 // Log.d(TAG, "Device attached");
            
            if (!mSerial.isOpened()) {
                // Log.d(TAG, "Device attached begin");
                
                openUsbSerial();
            }
            if (!mRunningMainLoop) {
                // Log.d(TAG, "Device attached mainloop");
                
                mainloop();
            }
        } else if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(action)) {
            // Log.d(TAG, "Device detached");
            
            mStop = true;
            detachedUi();
//            mSerial.usbDetached(intent);
            mSerial.close();
        } else if (ACTION_USB_PERMISSION.equals(action)) {
            // Log.d(TAG, "Request permission");
            
            synchronized (this) {
                if (!mSerial.isOpened()) {
                    // Log.d(TAG, "Request permission begin");
                    
                    openUsbSerial();
                }
            }
            if (!mRunningMainLoop) {
                // Log.d(TAG, "Request permission mainloop");
                
                mainloop();
            }
        }
    }
};

void tokenizer()
{
	 for(int i = 0; i < tokens.length; i++) 
	    tokArr[i] = Integer.parseInt(tokens[i]);
      
	 gx = tokArr[0];
     gy = tokArr[1];
     gz = tokArr[2];
     compass = tokArr[3];

     mTvSerial.append("gx :"+gx+", gy : "+gy+", gz :"+gz+", compass :"+compass);
}

// this is the last functions
/**
 * <p>Unescapes any Java literals found in the <code>String</code> to a
 * <code>Writer</code>.</p>
 *
 * <p>For example, it will turn a sequence of <code>'\'</code> and
 * <code>'n'</code> into a newline character, unless the <code>'\'</code>
 * is preceded by another <code>'\'</code>.</p>
 * 
 * <p>A <code>null</code> string input has no effect.</p>
 * 
 * @param out  the <code>String</code> used to output unescaped characters
 * @param str  the <code>String</code> to unescape, may be null
 * @throws IllegalArgumentException if the Writer is <code>null</code>
 * @throws IOException if error occurs on underlying Writer
 */
private String unescapeJava(String str) throws IOException {
    if (str == null) {
        return "";
    }
    int sz = str.length();
    StringBuffer unicode = new StringBuffer(4);

    StringBuilder strout = new StringBuilder();
    boolean hadSlash = false;
    boolean inUnicode = false;
    for (int i = 0; i < sz; i++) {
        char ch = str.charAt(i);
        if (inUnicode) {
            // if in unicode, then we're reading unicode
            // values in somehow
            unicode.append(ch);
            if (unicode.length() == 4) {
                // unicode now contains the four hex digits
                // which represents our unicode character
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    strout.append((char) value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                } catch (NumberFormatException nfe) {
                    // throw new NestableRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                    throw new IOException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            continue;
        }
        if (hadSlash) {
            // handle an escaped value
            hadSlash = false;
            switch (ch) {
                case '\\':
                    strout.append('\\');
                    break;
                case '\'':
                    strout.append('\'');
                    break;
                case '\"':
                    strout.append('"');
                    break;
                case 'r':
                    strout.append('\r');
                    break;
                case 'f':
                    strout.append('\f');
                    break;
                case 't':
                    strout.append('\t');
                    break;
                case 'n':
                    strout.append('\n');
                    break;
                case 'b':
                    strout.append('\b');
                    break;
                case 'u':
                    {
                        // uh-oh, we're in unicode country....
                        inUnicode = true;
                        break;
                    }
                default :
                    strout.append(ch);
                    break;
            }
            continue;
        } else if (ch == '\\') {
            hadSlash = true;
            continue;
        }
        strout.append(ch);
    }
    if (hadSlash) {
        // then we're in the weird case of a \ at the end of the
        // string, let's output it anyway.
        strout.append('\\');
    }
    return new String(strout.toString());
}

}
