package info.lucasdevil.viewtest;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;

public class MainActivity extends Activity {

    // Class variable for easier exchange.
    public static String EXTRA_KEY_DECIMAL_NUMBER = "DecimalNumberForCalculations";

    /** Instance or Member variables
     * Yeah, I really hate this 'mVariableName' stuff. We have syntax highlighting, so who the fuck needs an 'm' as prefix?
     */

    // Private means: no one can access this property from outside this class.
    private EditText decimalNumberInputEditText;    // Accessing the decimal number.


    /**
     * Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        // Setting the member variable to the EditText object in the layout.
        decimalNumberInputEditText = (EditText)findViewById(R.id.decimalNumberInputField);
    }

    /**
     * @abstract This Method is called from the main.xml layout when the button is clicked.
     * @param clickedView
     */
    public void calculationStartButtonOnClick(View clickedView) {
        // Setting the value I'm going to pass to the other intent.
        double inputNumber = 10.0d;

        // Now I'll try to read the number in the EditText.
        if(decimalNumberInputEditText != null && (!decimalNumberInputEditText.getText().toString().equalsIgnoreCase(""))) {
            String inputString = decimalNumberInputEditText.getText().toString();
            try {
                inputNumber = Double.parseDouble(inputString);
            }
            catch (NumberFormatException e) {
                // The string is something like 'Lecksmeomoarsch'. This should not happen, but who knows?
                // Catching this error is way more secure. But... What do we do if it appears?
                // Well, we'll inform the user.

                Toast.makeText(this, getString(R.string.input_is_not_a_number, inputString, inputNumber), Toast.LENGTH_LONG).show();
            }
        }
        // We don't have any EditText reference or it's value is an empty string. Again we'll inform the user.
        else {
            Toast.makeText(this, getString(R.string.no_input_made, inputNumber), Toast.LENGTH_LONG).show();
        }

        Intent calculationsIntent = new Intent(this, CalculationActivity.class);
        calculationsIntent.putExtra(EXTRA_KEY_DECIMAL_NUMBER, inputNumber);
        startActivity(calculationsIntent);
    }
}
