package info.lucasdevil.viewtest;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.TextView;

/**
 * Created by feltmann on 12.09.13 at 11:45
 * Copyright (c) 2013 tag new media GmbH & Co. KG. All rights reserved.
 */
public class CalculationActivity extends Activity {

    // Some more member variables: views
    private TextView decimalTextView;
    private TextView resultTextView;

    // Decimal value for the calculations.
    private double decimalNumber;

    @Override
    public void onCreate(Bundle savedInstance) {
        super.onCreate(savedInstance);
        setContentView(R.layout.calculation);

        decimalTextView = (TextView)findViewById(R.id.decimalNumber);
        resultTextView  = (TextView)findViewById(R.id.calculationResult);

        // Setting a start value since we don't know if there is something put in the extras.
        decimalNumber = 1.0d;

        // Trying to get the double value from the calling intent.
        Intent callingIntent;
        if((callingIntent = getIntent()) != null) {
            decimalNumber = callingIntent.getDoubleExtra(MainActivity.EXTRA_KEY_DECIMAL_NUMBER, 1.0d);
        }
    }

    @Override
    public void onResume() {
        super.onResume();

        double result = calculationResult(decimalNumber);

        decimalTextView.setText(getString(R.string.set_decimal_number, decimalNumber));
        resultTextView.setText(getString(R.string.calculation_result, decimalNumber, result));
    }

    public double calculationResult(double factor) {
        return Math.pow(2.0d, factor);
    }
}
