package com.example.testblablup;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.view.Menu;
import android.widget.Toast;

import com.example.testblablup.SingletonDownloader.SingletonDownloaderCallbacks;

public class MainActivity extends Activity implements SingletonDownloaderCallbacks{

	private Handler mHandler;


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		mHandler = new Handler();
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.activity_main, menu);
		return true;
	}


	@Override
	protected void onStart() {
		super.onStart();
		SingletonDownloader.getInstance().setListener(this);
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		SingletonDownloader.getInstance().setListener(null);
		SingletonDownloader.getInstance().stopDownloader();
	}

	@Override
	public void onProgressUpdate(final int percent) {
		mHandler.post(new Runnable() {
			@Override
			public void run() {
				Toast.makeText(MainActivity.this, "Progress: " + Integer.toString(percent), Toast.LENGTH_LONG).show();				
			}
		});		
	}

	@Override
	public void onError(final String errorMessage) {
		mHandler.post(new Runnable() {
			@Override
			public void run() {
				Toast.makeText(MainActivity.this, "Error: " + errorMessage, Toast.LENGTH_LONG).show();				
			}
		});		
	}

	@Override
	public void onFinished() {
		mHandler.post(new Runnable() {
			@Override
			public void run() {
				Toast.makeText(MainActivity.this, "FINISHED!!!", Toast.LENGTH_LONG).show();				
			}
		});		
	}

}
