package com.example.testblablup;

public class SingletonDownloader {

	//Callbacks
	public interface SingletonDownloaderCallbacks{
		public void onProgressUpdate(int percent);
		public void onError(String errorMessage);
		public void onFinished();
	}

	//Singleton
	private static SingletonDownloader mInstance;
	public static SingletonDownloader getInstance(){
		if (mInstance == null) mInstance = new SingletonDownloader();
		return mInstance;
	}


	//CallbackListener
	private SingletonDownloaderCallbacks mListener;
	public void setListener(SingletonDownloaderCallbacks listener){
		mListener = listener;
	}


	//Thread Membervariable
	private DlThread mThread;


	//Private Constructor
	private SingletonDownloader(){
		mThread = new DlThread();
		mThread.stopThread();
	};

	//Stop Downloader
	public void stopDownloader(){
		mThread.stopThread();
	}


	//Eigentlicher Thread
	private class DlThread extends Thread{
		private boolean _stop = false;

		public void stopThread(){
			_stop = true;
			this.interrupt();
			try {
				this.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		public void run() {
			while (!_stop){
				//deine Sachen downloaden
				//vielleicht whrend des downloads auf _stop prfen

				//progress update:
				if (mListener != null){
					mListener.onProgressUpdate(50);
				}

				//Fehler melden
				if (mListener != null){
					mListener.onError("UPPPPS");
				}

				//Fertig
				if (mListener != null){
					mListener.onFinished();
				}
				_stop = true;
			}
		}
	};

}
