package com.example.verbindung;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.app.Activity;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;
import android.support.v4.app.NavUtils;

public class Verbindung implements Runnable 
{
	private boolean running;
	private Socket socket;
	private BufferedReader input;
	private Handler myHandler;
	private String serverip ;


	public Verbindung(Handler handler, String ip) 
	{
		myHandler = handler;
		serverip = ip; 

	}

	
	public void run() 
	{
		
		
		try 
		{
			socket = new Socket(serverip, 4444);

			input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
			
			
		} 
		catch (UnknownHostException e1) 
		{
			e1.printStackTrace();
			Message msg = myHandler.obtainMessage();
			msg.obj = "Server nicht gestartet";
			myHandler.sendMessage(msg);
			stop();
			
		} 
		catch (IOException e1) 
		{
			e1.printStackTrace();
			Message msg = myHandler.obtainMessage();
			msg.obj = "Server nicht gestartet";
			myHandler.sendMessage(msg);
			stop();

		}
		
		while (running==true) 
		{
			try  
			{
				String s = input.readLine();
				Message msg = myHandler.obtainMessage();
				msg.obj = s;
				myHandler.sendMessage(msg);
				
			} 
			catch (IOException e) 
			{
				e.printStackTrace();
				Message msg = myHandler.obtainMessage();
				msg.obj = "Serververbindung unterbrochen";
				myHandler.sendMessage(msg);
				stop();

			}
		}
		
		
	}

	public void start() 
	{
		new Thread(this).start();
		running = true;
	
	}
	public void stop()
	{
		running = false;
		close();
	}
	
	private void close()
	{
		if(input != null)
		{
			try
			{
				input.close();
			}
			catch (IOException e)
			{
				Message msg = myHandler.obtainMessage();
				msg.obj = "Serververbindung unterbrochen";
				myHandler.sendMessage(msg);
			}
		}
		
		if(socket != null)
		{
			try
			{
				socket.close();
			}
			catch (IOException e)
			{
				Message msg = myHandler.obtainMessage();
				msg.obj = "Serververbindung unterbrochen";
				myHandler.sendMessage(msg);
			}
		}
	}
}