package com.example.csvimport

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import java.io.BufferedReader
import java.io.IOException
import java.io.InputStreamReader

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        val person = parseCsvFromAsset("data.csv")
        Log.d("CSVParser", person.toString())
    }

    private fun parseCsvFromAsset(dateiName: String): ArrayList<Person> {
        val results = ArrayList<Person>()
        val manager = assets
        try {
            manager.open(dateiName).use { `in` ->
                BufferedReader(InputStreamReader(`in`)).use { reader ->
                    var nextLine: String? = null
                    while (reader.readLine().also { nextLine = it } != null) {
                        val tokens = nextLine!!.split(";".toRegex()).dropLastWhile { it.isEmpty() }
                            .toTypedArray()
                        if (tokens.size != 3) {
                            Log.w("CSVParser", "Bad CSV Row")
                            continue
                        }
                        //Add new parsed result
                        val current = Person()
                        current.name = tokens[0]
                        current.color = tokens[1]
                        current.age = tokens[2]
                        results.add(current)
                    }
                    return results
                }
            }
        } catch (ex: IOException) {
            throw RuntimeException(ex)
        }
    }
}