package de.jw.viewlistkt

import android.content.Context
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.AdapterView.OnItemClickListener
import android.text.TextWatcher
import android.text.Editable
import android.util.Log
import android.view.ViewGroup
import android.view.LayoutInflater
import android.view.View
import android.widget.*
import java.util.*

class AndroidListViewCustomLayoutActivity : AppCompatActivity() {
    var dataAdapter: MyCustomAdapter? = null
    public override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_android_list_view_custom_layout)

        //Generate list View from ArrayList
        displayListView()
    }

    private fun displayListView() {

        //Array list of countries
        val countryList = ArrayList<Country>()
        var country = Country("AFG", "Afghanistan", "Asia",
            "Southern and Central Asia")
        countryList.add(country)
        country = Country("ALB", "Albania", "Europe", "Southern Europe")
        countryList.add(country)
        country = Country("DZA", "Algeria", "Africa", "Northern Africa")
        countryList.add(country)
        country = Country("ASM", "American Samoa", "Oceania", "Polynesia")
        countryList.add(country)
        country = Country("AND", "Andorra", "Europe", "Southern Europe")
        countryList.add(country)
        country = Country("AGO", "Angola", "Africa", "Central Africa")
        countryList.add(country)
        country = Country("AIA", "Anguilla", "North America", "Caribbean")
        countryList.add(country)

        //create an ArrayAdaptar from the String Array
        dataAdapter = MyCustomAdapter(this,
            R.layout.country_info, countryList)
        val listView = findViewById<View>(R.id.listView1) as ListView
        // Assign adapter to ListView
        listView.adapter = dataAdapter

        //enables filtering for the contents of the given ListView
        listView.isTextFilterEnabled = true
        listView.onItemClickListener =
            OnItemClickListener { parent, view, position, id -> // When clicked, show a toast with the TextView text
                val country = parent.getItemAtPosition(position) as Country
                Toast.makeText(applicationContext,
                    country.code, Toast.LENGTH_SHORT).show()
            }
        val myFilter = findViewById<View>(R.id.myFilter) as EditText
        myFilter.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(s: Editable) {}
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}
            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                dataAdapter!!.filter.filter(s.toString())
            }
        })
    }

    inner class MyCustomAdapter(
        context: Context?, textViewResourceId: Int,
        countryList: ArrayList<Country>?,
    ) : ArrayAdapter<Country?>(
        context!!, textViewResourceId, countryList!! as List<Country?>) {
        private val originalList: ArrayList<Country>
        private var countryList: ArrayList<Country>
        private var filter: CountryFilter? = null
        override fun getFilter(): Filter {
            if (filter == null) {
                filter = CountryFilter()
            }
            return filter!!
        }

        private inner class ViewHolder {
            var code: TextView? = null
            var name: TextView? = null
            var continent: TextView? = null
            var region: TextView? = null
        }

        override fun getView(position: Int, convertView: View?, parent: ViewGroup): View {
            var convertView = convertView
            var holder: ViewHolder? = null
            Log.v("ConvertView", position.toString())
            if (convertView == null) {
                val vi = getSystemService(
                    LAYOUT_INFLATER_SERVICE) as LayoutInflater
                convertView = vi.inflate(R.layout.country_info, null)
                holder = ViewHolder()
                holder!!.code = convertView.findViewById<View>(R.id.code) as TextView
                holder.name = convertView.findViewById<View>(R.id.name) as TextView
                holder.continent = convertView.findViewById<View>(R.id.continent) as TextView
                holder.region = convertView.findViewById<View>(R.id.region) as TextView
                convertView.tag = holder
            } else {
                holder = convertView.tag as ViewHolder
            }
            val country = countryList[position]
            holder!!.code!!.text = country.code
            holder.name!!.text = country.name
            holder.continent!!.text = country.continent
            holder.region!!.text = country.region
            return convertView!!
        }

        private inner class CountryFilter : Filter() {
            override fun performFiltering(constraint: CharSequence): FilterResults {
                var constraint: CharSequence? = constraint
                constraint = constraint.toString().lowercase(Locale.getDefault())
                val result = FilterResults()
                if (constraint != null && constraint.toString().length > 0) {
                    val filteredItems = ArrayList<Country>()
                    var i = 0
                    val l = originalList.size
                    while (i < l) {
                        val country = originalList[i]
                        if (country.toString().lowercase(Locale.getDefault())
                                .contains(constraint)
                        ) filteredItems.add(country)
                        i++
                    }
                    result.count = filteredItems.size
                    result.values = filteredItems
                } else {
                    synchronized(this) {
                        result.values = originalList
                        result.count = originalList.size
                    }
                }
                return result
            }

            override fun publishResults(
                constraint: CharSequence,
                results: FilterResults,
            ) {
                countryList = results.values as ArrayList<Country>
                notifyDataSetChanged()
                clear()
                var i = 0
                val l = countryList.size
                while (i < l) {
                    add(countryList[i])
                    i++
                }
                notifyDataSetInvalidated()
            }
        }

        init {
            this.countryList = ArrayList()
            this.countryList.addAll(countryList!!)
            originalList = ArrayList()
            originalList.addAll(countryList)
        }
    }
}