package com.example.jw.bottomtab.ui.dashboard;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;

import com.example.jw.bottomtab.MainViewModel;
import com.example.jw.bottomtab.R;



public class DashboardFragment extends Fragment implements View.OnClickListener {

    private DashboardViewModel dashboardViewModel;
    private MainViewModel mainViewModel;
    private EditText edText;



    public View onCreateView(@NonNull LayoutInflater inflater,
                             ViewGroup container, Bundle savedInstanceState) {

        dashboardViewModel = ViewModelProviders.of(this).get(DashboardViewModel.class);
        View root = inflater.inflate(R.layout.fragment_dashboard, container, false);
        final TextView textView = root.findViewById(R.id.text_dashboard);
        dashboardViewModel.getText().observe(this, new Observer<String>() {
            @Override
            public void onChanged(@Nullable String s) {
                textView.setText(s);
            }
        });

        mainViewModel = ViewModelProviders.of(getActivity()).get(MainViewModel.class);
        edText = root.findViewById(R.id.edDashboard);
        Button bt = root.findViewById(R.id.button1);
        bt.setOnClickListener(this);

        return root;
    }

    @Override
    public void onClick(View v) {
        String st = edText.getText().toString();
        mainViewModel.setmNotiText(st);

    }
}