package com.example.lagermanager;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.TextView;

import java.util.List;

public class Arbeitsauftraege_CustomList_Adapter extends ArrayAdapter<Arbeitsauftraege_item> {

    Context context;
    int resource;
    List<Arbeitsauftraege_item> arbeitsauftraege_list;

    public Arbeitsauftraege_CustomList_Adapter(Context context, int resource, List<Arbeitsauftraege_item> arbeitsauftraege_list) {
        // Konstruktor zum Verwenden des Arbeitsaufträge-Layouts
        super(context, resource, arbeitsauftraege_list);
        this.context = context;
        this.resource = resource;
        this.arbeitsauftraege_list = arbeitsauftraege_list;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from(context); // Definiert Activity, auf die der Inflater angewendet wird
        View view = inflater.inflate(resource, null); // Elemente der Volage werden an Inflater übergeben

        TextView tv_name = view.findViewById(R.id.tv_name);
        TextView tv_id = view.findViewById(R.id.tv_id);
        TextView tv_beschreibung = view.findViewById(R.id.tv_beschreibung);
        CheckBox cb_status = view.findViewById(R.id.cb_status);

        Arbeitsauftraege_item a_item = arbeitsauftraege_list.get(position);

        tv_name.setText(a_item.getA_titel());
        tv_beschreibung.setText(a_item.getA_beschreibung());
        tv_id.setText(a_item.getA_id());
        cb_status.setText(a_item.getA_statustext());
        // cb_status.setChecked(a_item.getA_status());

        return view;
    }
}
